package com.burhanstore.neonbubblequest.Utils.network


import com.google.gson.JsonObject
import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.launch

object ScNetworkAdapter {

    interface ResponseHandler {
        fun onSuccess(response: JsonObject?)
        fun onError(code: Int, message: String?)
        fun onException(exception: Exception)
    }

    fun sendRequest(
        scope: CoroutineScope?, // Pass activity.lifecycleScope
        data: JsonObject,
        handler: ResponseHandler
    ) {

        val secretKey = CryptoUtil.generateAESKey()
        val encryptedData = CryptoUtil.encrypt(data, secretKey)
        val payload = JsonObject().apply {
            addProperty("data", encryptedData)
            addProperty("key", CryptoUtil.keyToString(secretKey))
        }

        scope?.launch {
            try {
                val response = RetrofitClient.api.sendScRequest(payload)
                if (response.isSuccessful) {
                    handler.onSuccess(response.body())
                } else {
                    handler.onError(
                        response.code(),
                        response.errorBody()?.string()
                    )
                }
            } catch (e: Exception) {
                handler.onException(e)
            }
        }
    }

}
